////temp:
//function AddNumberParam() {};
//function AddStringParam() {};

function GetPluginSettings() {
    return {
        "name":			"Jalaali Date",
        "id":			"Jalaali",
        "version":		"1.0",
        "description":	"پلاگینی برای کار با تقویم هجری شمسی",
        "author":		"مجتبی قاسم‌زاده تهرانی",
        "help url":		"http://construct2.ir/plugins/jalaali-calendar",
        "category":		"Data & Storage",
        "dependency":   "jdate.min.js",
        "type":			"object",
        "rotatable":	false,
        "flags":		pf_singleglobal
    };
}

var currentYear = (function () {
    
    var today = new Date(),
        year = today.getFullYear() - 621,
        gMonth = today.getMonth();
    
    if (gMonth === 1 || (gMonth === 2 && today.getDate() < 20))
        --year

    return year;
    
})();

// Conditions
AddNumberParam('سال جلالی', 'سالی را که می‌خواهید کبیسه بودن آن بررسی شود وارد کنید، اگر ۰ وارد کنید سال جاری بررسی می‌شود', currentYear.toString());
AddCondition(0, cf_none, 'آیا کبیسه است', 'هجری شمسی', 'آیا {0} کبیسه است', "از این شرط برای بررسی کبیسه بودن یک سال هجری شمسی استفاده می‌شود", "isLeapYear");

AddCondition(1, cf_none, 'آیا اعداد فارسی هستند', 'تنظیمات', 'آیا اعداد فارسی است', 'بررسی فارسی یا انگلیسی بودن اعداد برگشتی از پلاگین', 'IsPersian');

// Actions
AddComboParamOption("فارسی");
AddComboParamOption("انگلیسی");
AddComboParam('اعداد', 'زبان اعداد دریافتی از این پلاگین');
AddAction(0, af_none, "تعیین زبان اعداد دریافتی", "تنظیمات", "اعداد {0} شوند", "تعیین انگلیسی یا فارسی بودن اعداد دریافتی از پلاگین", "SetDigits");

// Expressions
AddExpression(0, ef_return_string, 'Today', 'گرفتن اطّلاعات', 'Today', 'تاریخ امروز (هجری شمسی) در قالب دیکشنری');

AddNumberParam('سال‌میلادی', 'سال میلادی را برای تبدیل وارد کنید');
AddNumberParam('ماه‌میلادی', 'ماه میلادی را وارد کنید');
AddNumberParam('روز‌میلادی', 'روز مورد نظر از ماه میلادی را برای تبدیل به هجری شمسی وارد کنید');
AddExpression(1, ef_return_string, 'Gregorian to Jalali', 'تبدیل تاریخ', 'ToJalali', 'تبدیل تاریخ میلادی به جلالی در قالب دیکشنری');

AddNumberParam('سال‌جلالی', 'سال هجری شمسی مورد نظر را وارد کنید');
AddNumberParam('ماه‌جلالی', 'برج مورد نظر را وارد کنید');
AddNumberParam('روز‌جلالی', 'روز مورد نظر از برج را برای تبدیل به میلادی وارد کنید');
AddExpression(2, ef_return_string, 'Jalali to Gregorian', 'تبدیل تاریخ', 'ToGregorian', 'تبدیل تاریخ جلالی به میلادی در قالب دیکشنری');

AddNumberParam('سال‌جلالی', 'سال هجری شمسی مورد نظر را وارد کنید', '1395');
AddNumberParam('ماه‌جلالی', 'برج مورد نظر را وارد کنید', '7');
AddExpression(3, ef_return_any, 'تعداد روزهای برج', 'گرفتن اطّلاعات', 'DaysInMonth', 'گرفتن تعداد روزهای یک ماه در تقویم هجری شمسی');

AddNumberParam('سال‌جلالی', 'سال هجری شمسی مورد نظر را وارد کنید');
AddNumberParam('ماه‌جلالی', 'برج مورد نظر را وارد کنید');
AddNumberParam('روز‌جلالی', 'روز مورد نظر از برج را وارد کنید');
AddStringParam('فرمت', 'قالبی که می‌خواهید تاریخ در آن نمایش داده شود وارد کنید');
AddExpression(4, ef_return_string, 'Format Dictionary', 'قالب', 'Format', 'فرمت تاریخ جلالی');

AddStringParam('تاریخ‌از‌دیکشنری', 'تاریخ مورد نظر را در قالب یک دیکشنری که به جی‌سان تبدیل شده وارد کنید');
AddStringParam('فرمت', 'قالبی که می‌خواهید تاریخ در آن نمایش داده شود وارد کنید');
AddExpression(5, ef_return_string, 'Format Dictionary', 'قالب', 'FormatDictionary', 'فرمت تاریخ جلالی که در قالب دیکشنری دریافت شده');

ACESDone();

var property_list = [
    new cr.Property(ept_combo, 'digits', 'انگلیسی', 'تنظیم این‌که آیا اعدادی که این پلاگین به شما می‌دهد فارسی باشند یا نه', "فارسی|انگلیسی")
];

function CreateIDEObjectType() {
    return new IDEObjectType();
}

function IDEObjectType() {
    assert2(this instanceof arguments.callee, "Constructor called as a function");
}

IDEObjectType.prototype.CreateInstance = function(instance) {
    return new IDEInstance(instance);
};

function IDEInstance(instance, type) {
    assert2(this instanceof arguments.callee, "Constructor called as a function");
    this.instance = instance;
    this.type = type;
    this.properties = {
        digits: "انگلیسی"
    };
}
